using System;
using System.Collections;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.ExceptionManagement;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{
	#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/14/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///	Data access component providing database access and manipulation to the 
		///	outgoing shipment data.
		///</summary>

	#endregion

    public class OutgoingShipment
    {
       
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/6/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1615"> 
		///		<ExpectedInput>Division, ShipmentGuid, ShipDate, RowVersion, LastUpdateFunctionId, Workload DataTable</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1616"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
        ///<summary>Confirms shipment</summary>
        ///<param name="dtShipment">Shipment to update</param>
        ///<param name="bloodUnits">Blood units within shipment to update</param>
        ///<param name="workloadEvents">Data table of workload event data</param>
		///<param name="dtBCEMessages">BCE Messages</param>
		///<returns>True or False</returns>
		public static bool ConfirmShipment
		(
			System.Data.DataTable workloadEvents,
			System.Data.DataTable bloodUnits,
			System.Data.DataTable dtShipment,
			System.Data.DataTable dtBCEMessages
		)
		{
			//CR 2941, CR 2945 Added dtBCEMessages
			DataTable[] dtArray = new DataTable[4];
			string[] spArray = new string[4];
						
			dtArray[0] = dtShipment;
			spArray[0] = STOREDPROC.ConfirmOutgoingShipment.StoredProcName;
			dtArray[1] = bloodUnits;
			spArray[1] = STOREDPROC.ConfirmOutgoingShipmentBloodUnit.StoredProcName;
			dtArray[2] = workloadEvents;
			spArray[2] = STOREDPROC.InsertWorkloadEvents.StoredProcName;
			dtArray[3] = dtBCEMessages;
			spArray[3] = STOREDPROC.HL7InsertMessageLog.StoredProcName;

			
			int retVal = new StoredProcedure().TransactionalGetValue(spArray, dtArray);
			
			return (retVal == 0);
		}


		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/6/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2556"> 
		///		<ExpectedInput>Invoice Number, LocalSupplierGuid, ShipmentDate, ShipmentType, UserId, UpdateFunction</ExpectedInput>
		///		<ExpectedOutput>DataTable of Outgoing Invoice</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2557"> 
		///		<ExpectedInput>Invalid Fields</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
        ///<summary>Creates outgoing shipment (invoice)</summary>
        ///<param name="shipmentGuid">Shipment Guid</param>
        ///<param name="localSupplierGuid">Local Shipper Guid</param>
        ///<param name="shipmentType">Shipment type</param>
        ///<param name="invoiceNumber">Invoice (shipment) number</param>
        ///<param name="ntUserId">Updating user ID</param>
        ///<param name="lastUpdateFunctionId">UC or calling method</param>
        public static int CreateOutgoingInvoice
		(
			Guid shipmentGuid, 
			Guid localSupplierGuid,
			char shipmentType,
			string invoiceNumber,
			string ntUserId, 
			Common.UpdateFunction lastUpdateFunctionId
		)
        {
            SqlParameter[] parameters = 
			{
					Common.StoredProcedure.MakeParameter(STOREDPROC.CreateOutgoingInvoice.shipmentguid, shipmentGuid),
                    Common.StoredProcedure.MakeParameter(STOREDPROC.CreateOutgoingInvoice.invoicenumber, invoiceNumber),
                    Common.StoredProcedure.MakeParameter(STOREDPROC.CreateOutgoingInvoice.localsupplierguid, localSupplierGuid),
                    Common.StoredProcedure.MakeParameter(STOREDPROC.CreateOutgoingInvoice.shipmenttypecode, shipmentType),
                    Common.StoredProcedure.MakeParameter(STOREDPROC.CreateOutgoingInvoice.divisioncode, Common.LogonUser.LogonUserDivisionCode),
                    Common.StoredProcedure.MakeParameter(STOREDPROC.CreateOutgoingInvoice.lastupdateuser, ntUserId),
					Common.StoredProcedure.MakeParameter(STOREDPROC.CreateOutgoingInvoice.lastupdatefunctionid, (int)lastUpdateFunctionId),
			};

            return new StoredProcedure().TransactionalGetValue( STOREDPROC.CreateOutgoingInvoice.StoredProcName, parameters );
        }

		///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>3/6/2003</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="1627"> 
        ///		<ExpectedInput>Division, TestTypeId, TestResultId</ExpectedInput>
        ///		<ExpectedOutput>Valid data table</ExpectedOutput>
        ///	</Case>
        ///
        ///<Case type="1" testid ="1628"> 
        ///		<ExpectedInput>Invalid parameters</ExpectedInput>
        ///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// Get blood unit test results for division
        /// </summary>
        /// <param name="divisionCode">Division code</param>
        /// <param name="testTypeId">Test type ID</param>
        /// <param name="result">Test result ID</param>
        /// <returns>DataTable containing test result data</returns>
        public static DataTable GetBloodUnitTestResultsForDivision(string divisionCode, int testTypeId, string result)
        {
            SqlParameter[] prms =
            {
                new SqlParameter(STOREDPROC.GetBloodUnitTestResultsForDivision.divisioncode, System.Data.SqlDbType.VarChar),
                new SqlParameter(STOREDPROC.GetBloodUnitTestResultsForDivision.bloodtesttypeid, System.Data.SqlDbType.Int),
                new SqlParameter(STOREDPROC.GetBloodUnitTestResultsForDivision.testresultid, System.Data.SqlDbType.VarChar)
            };

            prms[0].Value = divisionCode;
            prms[1].Value = testTypeId;
            prms[2].Value = result;

			return Common.StoredProcedure.GetData(STOREDPROC.GetBloodUnitTestResultsForDivision.StoredProcName, prms).Tables[0];
        }

		//TODO:Move to BloodUnitTest
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>3/6/2003</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="2558"> 
        ///		<ExpectedInput>Valid division code</ExpectedInput>
        ///		<ExpectedOutput>Valid data table</ExpectedOutput>
        ///	</Case>
        ///
        ///<Case type="1" testid ="2559"> 
        ///		<ExpectedInput>Inavlid Division</ExpectedInput>
        ///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// Gets blood unit test results for a given division
        /// </summary>
        /// <param name="divisionCode">Division code</param>
        /// <returns>DataTable containing blood units test results</returns>
        public static DataTable GetBloodUnitTestResultsForDivision(string divisionCode)
        {
            SqlParameter[] prms =
            {
                new SqlParameter(STOREDPROC.GetBloodUnitTestResultsForDivision.divisioncode, System.Data.SqlDbType.VarChar),
            };

            prms[0].Value = divisionCode;

			return Common.StoredProcedure.GetData(STOREDPROC.GetBloodUnitTestResultsForDivision.StoredProcName, prms).Tables[0];
        }

        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>12/11/2002</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="1035"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>The data table containing the list of eligible units for division</ExpectedOutput>
        ///	</Case>
        ///
        ///<Case type="1" testid ="2560"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// Gets the list of eligible units for a given division
        /// </summary>
        /// <returns>DataTable containing blood units data</returns>
        public static DataTable GetEligibleUnitsForDivision()
        {
            SqlParameter[] prms =
            {
                new SqlParameter(STOREDPROC.GetEligibleUnitsForDivision.divisioncode, System.Data.SqlDbType.VarChar)
            };

            prms[0].Value = Common.LogonUser.LogonUserDivisionCode;

            return Common.StoredProcedure.GetData(STOREDPROC.GetEligibleUnitsForDivision.StoredProcName, prms).Tables[0];
        }


		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/6/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1617"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of InvoiceTest</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1618"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
        ///<summary>Gets invoice text for a given division</summary>
        public static DataTable GetInvoiceText()
        {
	        return StoredProcedure.GetData(STOREDPROC.GetInvoiceText.StoredProcName, Common.StoredProcedure.MakeParameter(STOREDPROC.GetInvoiceText.divisioncode,Common.LogonUser.LogonUserDivisionCode)).Tables[0];
        }



		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/6/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1619"> 
		///		<ExpectedInput>Invoice Number, LocalSupplierGuid, ShipmentDate, DivisionCode</ExpectedInput>
		///		<ExpectedOutput>DataSet of invoice</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1620"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
        ///<summary>Gets outgoing invoice</summary>
        ///<param name="invoiceNumber">Invoice number</param>
        ///<param name="localSupplierGuid">Local Shipper GUID</param>
        ///<param name="shipmentDate">Ship date</param>
        ///<param name="divisionCode">Division code</param>
        ///<returns>DataSet containing outgoing shipment data</returns>
        public static DataSet GetOutgoingInvoice
							(
								string invoiceNumber,
								System.Guid localSupplierGuid,
								DateTime shipmentDate,
								string divisionCode
							) 
        {
            return StoredProcedure.GetData(STOREDPROC.GetOutgoingInvoice.StoredProcName,
                Common.StoredProcedure.MakeParameter(STOREDPROC.GetOutgoingInvoice.invoicenumber, invoiceNumber),
                Common.StoredProcedure.MakeParameter(STOREDPROC.GetOutgoingInvoice.localsupplierguid,localSupplierGuid),
                Common.StoredProcedure.MakeParameter(STOREDPROC.GetOutgoingInvoice.shipmentdate, shipmentDate),
                Common.StoredProcedure.MakeParameter(STOREDPROC.GetOutgoingInvoice.divisioncode,divisionCode));
        }


		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/6/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1621"> 
		///		<ExpectedInput>ShipmentGuid</ExpectedInput>
		///		<ExpectedOutput>DataSet of Outgoing Invoice</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1624"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
        ///<summary>Gets outgoing invoice data by GUID</summary>
        ///<param name="shipmentGuid">Shipment GUID</param>
        ///<returns>DataSet containing outgoing invoice data</returns>
        public static DataSet GetOutgoingInvoiceByGuid(System.Guid shipmentGuid) 
        {
            return StoredProcedure.GetData(STOREDPROC.GetOutgoingInvoiceByGuid.StoredProcName, 
                Common.StoredProcedure.MakeParameter(STOREDPROC.GetOutgoingInvoiceByGuid.shipmentguid,shipmentGuid),
				Common.StoredProcedure.MakeParameter(STOREDPROC.GetOutgoingInvoice.divisioncode,Common.LogonUser.LogonUserDivisionCode));

        }

         ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>3/6/2003</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="2569"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>DataTable</ExpectedOutput>
        ///	</Case>
        ///
        ///<Case type="1" testid ="2570"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// Gets recent invoices for division
        /// </summary>
        /// <returns>DataTable containing invoices data</returns>
        public static DataTable GetRecentInvoicesForDivision()
        {
            SqlParameter[] prms =
            {
                new SqlParameter(STOREDPROC.GetRecentInvoicesForDivision.divisioncode, System.Data.SqlDbType.VarChar)
            };

            prms[0].Value = Common.LogonUser.LogonUserDivisionCode;

			return Common.StoredProcedure.GetData(STOREDPROC.GetRecentInvoicesForDivision.StoredProcName, prms).Tables[0];
        }

        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>3/6/2003</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="2573"> 
        ///		<ExpectedInput>ShipmentGuid</ExpectedInput>
        ///		<ExpectedOutput>DataTable</ExpectedOutput>
        ///	</Case>
        ///
        ///<Case type="1" testid ="2574"> 
        ///		<ExpectedInput>Invalid Guid</ExpectedInput>
        ///		<ExpectedOutput>Empty DataSet</ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// Gets shipment report data
        /// </summary>
        /// <param name="shipmentGuid">Shipment GUID</param>
        /// <returns>DataSet containing report data</returns>
        public static DataSet GetReportDataSet(System.Guid shipmentGuid)
        {
            SqlParameter[] prms =
            {
                new SqlParameter(STOREDPROC.OutGoingInvoiceReport2.shipmentguid, System.Data.SqlDbType.UniqueIdentifier),
                new SqlParameter(STOREDPROC.OutGoingInvoiceReport2.divisioncode, System.Data.SqlDbType.Char)
			};

            prms[0].Value = shipmentGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;

            DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.OutGoingInvoiceReport2.StoredProcName, prms);

            return ds;
        }


		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/6/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1629"> 
		///		<ExpectedInput>ShipmentGuid</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1630"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetUnitsInInvoice
		/// </summary>
		/// <param name="shipmentGuid">shipmentGuid</param>
		/// <returns>Data table</returns>
        public static DataTable GetUnitsInInvoice(System.Guid shipmentGuid)
        {
            return StoredProcedure.GetData(STOREDPROC.GetUnitsInInvoice.StoredProcName, 
                Common.StoredProcedure.MakeParameter(STOREDPROC.GetUnitsInInvoice.shipmentguid,
                shipmentGuid)).Tables[0];
        }

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/16/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5962"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5963"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// RemoveAllUnitsFromInvoice
		/// </summary>
		///<param name="dtBloodUnitShipment">Units to remove from invoice.</param>
		///<param name="dtShipment">Shipment to remove.</param>
		public static void RemoveAllUnitsFromInvoice
			(
				DataTable dtShipment,
				DataTable dtBloodUnitShipment
			)
		{
			ArrayList spArray=new ArrayList();
			ArrayList dtArray=new ArrayList();

			if(dtShipment.Rows.Count>0)
			{
				dtArray.Add(dtShipment);
				spArray.Add(Common.VbecsStoredProcs.RemoveAllUnitsFromShipment.StoredProcName);
			}
			if(dtBloodUnitShipment.Rows.Count>0)
			{
				dtArray.Add(dtBloodUnitShipment);
				spArray.Add(Common.VbecsStoredProcs.RemoveAllUnitsFromBloodUnitShipment.StoredProcName);
			}
			int retVal = new StoredProcedure().TransactionalGetValue(spArray,dtArray);
		}

        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>3/6/2003</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="2583"> 
        ///		<ExpectedInput>User, InvoiceText, UpdateFunction</ExpectedInput>
        ///		<ExpectedOutput>true</ExpectedOutput>
        ///	</Case>
        ///
        ///<Case type="1" testid ="2584"> 
        ///		<ExpectedInput>Invalid Row Version</ExpectedInput>
        ///		<ExpectedOutput>RowVersionException</ExpectedOutput>
        ///	</Case>
        ///
        ///</TestCases>
        ///<Update> 11/30/2004 - Added rowversion to the parameter list. The rowversion
        /// is now passed to the stored procedure.</Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// Updates invoice text
        /// </summary>
        /// <param name="vbecsUser">Updating user ID</param>
        /// <param name="invoiceText">Invoice text</param>
        /// <param name="lastUpdateFunctionId">UC or calling method</param>
        /// <param name="rowversion">timestamp of the division record</param>
        /// <returns>True on success. Otherwise - false.</returns>
        public static bool UpdateInvoiceText(string vbecsUser, string invoiceText, Common.UpdateFunction lastUpdateFunctionId, byte[] rowversion)
        {
			SqlParameter[] parameters = {
											Common.StoredProcedure.MakeParameter(STOREDPROC.UpdateInvoiceText.divisioncode, Common.LogonUser.LogonUserDivisionCode),
											Common.StoredProcedure.MakeParameter(STOREDPROC.UpdateInvoiceText.lastupdateuser, vbecsUser),
											Common.StoredProcedure.MakeParameter(STOREDPROC.UpdateInvoiceText.invoicetemplatetext, invoiceText),
											Common.StoredProcedure.MakeParameter(STOREDPROC.UpdateInvoiceText.lastupdatefunctionid, (int)lastUpdateFunctionId),
											//Added 11/30/2004
											Common.StoredProcedure.MakeParameter(STOREDPROC.UpdateInvoiceText.rowversion, rowversion),
			};

			int retValue = new StoredProcedure().TransactionalGetValue(STOREDPROC.UpdateInvoiceText.StoredProcName,parameters);
			
			return(retValue == 0);
        }

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/17/2005</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="7303"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7304"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets count of shipment invoices that meet the 'UCK_Shipment' constraint.
		/// </summary>
		/// <param name="localSupplierGuid">Local Supplier Guid</param>
		/// <param name="invoiceNumber">Invoice Number</param>
		/// <returns>count (int)</returns>
		public static int GetShipmentInvoiceCount( Guid localSupplierGuid, string invoiceNumber )
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetShipmentInvoiceCount.divisioncode, SqlDbType.Char),
				new SqlParameter(STOREDPROC.GetShipmentInvoiceCount.localsupplierguid, SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetShipmentInvoiceCount.invoicenumber, SqlDbType.VarChar)
			};
			//
			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			prms[1].Value = localSupplierGuid;
			prms[2].Value = invoiceNumber;
			//
			return new StoredProcedure().GetIntReturnValue( STOREDPROC.GetShipmentInvoiceCount.StoredProcName, prms );
		}
    }
}


